<?php

/******************************************************************************
 *
 *	PROJECT: Flynax Classifieds Software
 *	VERSION: 4.8.2
 *	LICENSE: FL7PX995723I - https://www.flynax.com/license-agreement.html
 *	PRODUCT: Auto Classifieds Script
 *	DOMAIN: autobsm-llc.com
 *	FILE: RLXMLEXPORT.CLASS.PHP
 *
 *	The software is a commercial product delivered under single, non-exclusive,
 *	non-transferable license for one domain or IP address. Therefore distribution,
 *	sale or transfer of the file in whole or in part without permission of Flynax
 *	respective owners is considered to be illegal and breach of Flynax License End
 *	User Agreement.
 *
 *	You are not allowed to remove this information from the file without permission
 *	of Flynax respective owners.
 *
 *	Flynax Classifieds Software 2024 |  All copyrights reserved.
 *
 *	https://www.flynax.com/
 *
 ******************************************************************************/

class rlXmlExport {

    private $format_info = array();

    function __construct($format) {
        global $reefless, $rlXmlMapping;

        $reefless->loadClass('Listings');
        $reefless->loadClass('ListingTypes');
        $reefless->loadClass('Cache');
        $reefless->loadClass('Valid');
        $reefless->loadClass('XmlMapping', null, 'xmlFeeds');

        $GLOBALS['rlCommon']->getInstalledPluginsList();

        $rlXmlMapping->format = $format;
        $rlXmlMapping->loadBasicMapping('export');
        $rlXmlMapping->getMultifieldRelatedFileds();

        $this->format_info = $GLOBALS['rlDb']->fetch('*', array('Key' => $format), null, null, 'xml_formats', 'row');
    }

    public function export($fp, $where, $order, $total_limit, $type) {
        global $rlXmlMapping;

        $xml = '<?xml version="1.0" encoding="utf-8" ?>';

        $xpath = explode("/", $this->format_info['Xpath']);
        if (count($xpath) == 1) {
            $xpath[1] = $xpath[0];
            $xpath[0] = 'data';
        }
        $last = current(array_splice($xpath, -1, 1));

        foreach ($xpath as $xk => $xp) {
            $xml .= '<' . $xp . '>';
        }
        fwrite($fp, $xml);unset($xml);

        $limit = 10;

        if ($total_limit < $limit) {
            $limit = $total_limit;
        }

        while ($listings = $this->getListings($where, $order, $start, $limit, $type)) {
            foreach ($listings as $key => $listing) {
                $xml = $this->exportListing($listing, $last);
                fwrite($fp, $xml);
            }
            $start = $start + $limit;
            if ($start >= $total_limit) {
                break;
            }
        }

        $xml = '';
        foreach (array_reverse($xpath) as $xk => $xp) {
            $xml .= '</' . $xp . '>';
        }
        fwrite($fp, $xml);
    }

    private function exportListing($listing, $last) {
        global $rlXmlMapping, $rlDb;

        foreach ($rlXmlMapping->mapping as $flynax_field => $xml_field) {
            if (strpos($xml_field, '@') > 0) {
                continue;
            }

            if (strpos($xml_field . "_", $last)) {
                $xml_field = substr($xml_field, strlen($last)+1);
            }

            if ($flynax_field == 'xml_ref') {
                $advert[$xml_field] = $listing[$flynax_field] ?: $listing['ID'];
            } elseif (preg_match('#sys_category_[0-9]#', $flynax_field)) {
                if (!$cats_out[$flynax_field]) {
                    $sql = "SELECT `Key`, `Level` FROM `{db_prefix}categories` ";
                    $sql .= "WHERE `ID` = " . $listing['Category_ID'];
                    $sql .=" OR FIND_IN_SET(`ID`, ";
                        $sql .="(SELECT `Parent_IDs` FROM `{db_prefix}categories` WHERE `ID` = {$listing['Category_ID']}))";

                    $keys = $rlDb->getAll($sql);
                    $sql = "SELECT `Key`, `Value` FROM `{db_prefix}lang_keys` WHERE (";
                    foreach ($keys as $k => $v) {
                        $levels[$v['Key']] = $v['Level'];
                        $sql .= "`Key` = 'categories+name+" . $v['Key'] . "' OR ";
                    }
                    $sql = substr($sql, 0, -3);
                    $sql .=") AND `Code` = '{$GLOBALS['config']['lang']}'";
                    $names = $rlDb->getAll($sql);

                    foreach ($names as $key => $value) {
                        $cat_key = str_replace('categories+name+', '', $value['Key']);
                        $cats_out['sys_category_' . $levels[$cat_key]] = $value['Value'];
                    }
                }

                $advert[$xml_field] = $cats_out[$flynax_field];
            } elseif ($flynax_field == 'sys_photos') {
                $photos = $rlDb->fetch("*", array('Listing_ID' => $listing['ID']), null, null, 'listing_photos');
                if ($photos) {
                    foreach ($photos as $pk => $photo) {
                        $advert['photos'][]['photo'] = RL_FILES_URL.$photo['Photo'];
                    }
                }
            } elseif ($flynax_field == 'sys_loc_latitude' || $flynax_field == 'sys_loc_longitude') {
                $flynax_field = $flynax_field == 'sys_loc_latitude' ? 'Loc_latitude' : 'Loc_longitude';
                $advert[$xml_field] = $listing[$flynax_field];
            } elseif ($flynax_field == 'sys_dealer_id') {
                $advert[$xml_field] = $listing['Username'];
            } elseif ($flynax_field == 'xml_back_url') {
                $advert[$xml_field] = $GLOBALS['reefless']->getListingUrl((int) $listing['ID']);
            } elseif ($listing[$flynax_field]) {
                $field_info = $rlXmlMapping->fields_info[$flynax_field];

                switch ($field_info['Type']) {
                    case 'price':
                        $advert[$xml_field] = preg_replace("/\|.*$/", "", $listing[$flynax_field]);
                    break;
                    case 'select':
                    case 'radio':
                        if ($field_info['Condition'] == 'years') {
                            $advert[$xml_field] = $listing[$flynax_field];
                        }else if ($field_info['Condition']) {
                            if (in_array($flynax_field,$rlXmlMapping->multiFormatKeys)) {
                                if ($rlXmlMapping->isNewMultiField) {
                                    $GLOBALS['rlMultiField']->getNames($listing[$flynax_field]);
                                    $advert[$xml_field] = $GLOBALS['lang']['data_formats+name+' . $listing[$flynax_field]];
                                } else {
                                    $advert[$xml_field] = $rlDb->getOne("Value", "`Key` ='data_formats+name+" . $listing[$flynax_field] . "'", "lang_keys");
                                }
                            } else {
                                $advert[$xml_field] = $rlXmlMapping->data_formats_mapping[$field_info['Condition']][$listing[$flynax_field]];
                            }
                        } else {
                            $advert[$xml_field] = $rlXmlMapping->listing_fields_mapping[$flynax_field][$listing[$flynax_field]];
                        }
                    break;
                    case 'checkbox':
                        $advert[$xml_field] = $this->adaptFeatures($field_info, $listing[$flynax_field], ',', $rlXmlMapping->listing_fields_mapping[$flynax_field]);
                        break;
                    case 'mixed':
                        $tval = explode("|", $listing[$flynax_field]);
                        $advert[$xml_field] = $tval[0];
                        break;
                    default:
                        $advert[$xml_field] = $listing[$flynax_field];
                        break;
                }
            }
        }

        $data[$last] = $advert;

        $xml = $this->toXML($data);
        $xml = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $xml);//replace & with &amp;

        return $xml;
    }

    /**
    * function getListings
    *
    * @param array $where  - conditions array
    * @param string $order - order
    * @param int $start    - start
    * @param int $limit    - limit
    * @param type $type    - listing type
    */
    function getListings($where = false, $order= false, $start =0, $limit = 100, $type = false)
    {
        global $rlDb;

        $start = $start ? $start : 0;
        $limit = $limit ? $limit : 10;

        $sql = "SELECT `T1`.*, `T3`.`Path` AS `Path`, `T3`.`Type` AS `Listing_type`, `T3`.`Path` as `Category_path`, `T7`.`Username`, ";
        $sql .= "IF(`T1`.`Featured_date`, '1', '0') `Featured` ";
        $sql .= "FROM `{db_prefix}listings` AS `T1` ";
        $sql .= "LEFT JOIN `{db_prefix}categories` AS `T3` ON `T1`.`Category_ID` = `T3`.`ID` ";
        $sql .= "LEFT JOIN `{db_prefix}accounts` AS `T7` ON `T1`.`Account_ID` = `T7`.`ID` ";
        #$sql .= "LEFT JOIN `{db_prefix}account_types` AS `T8` ON `T7`.`Type` = `T8`.`Key` ";
        $sql .= "WHERE `T1`.`Status` = 'active' ";

        foreach ($where as $key => $value) {
            if ($key == 'category') {
                $sql .= "AND (`T1`.`Category_ID` = '{$value}' OR (FIND_IN_SET('{$value}', `T1`.`Crossed`) > 0 AND `T2`.`Cross` > 0 ) ";
                $sql .= "OR FIND_IN_SET('{$value}', `T3`.`Parent_IDs`) > 0 ) ";
            } else {
                $sql .="AND `T1`.`{$key}` = '{$GLOBALS['rlValid'] -> xSql($value)}' ";
            }
        }

        $GLOBALS['rlHook']->load('listingsModifyWhere');

        if ($type) {
            $sql .= "AND `T3`.`Type` = '{$type}' ";
        }

        if ($featured) {
            $sql .="AND `T1`.`Featured_date` ";
        }

        $sql .= "GROUP BY `ID` ";

        if ($order) {
            $sql .= "ORDER BY `T1`.`{$order['field']}` {$order['type']}, ";
        }
        $sql .= "`ID` DESC ";
        $sql .= "LIMIT {$start}, {$limit} ";

        $listings = $rlDb->getAll($sql);
        $listings = $GLOBALS['rlLang']->replaceLangKeys($listings, 'categories', 'name');

        foreach ($listings as $key => $value) {
            $listings[$key]['listing_title'] = $GLOBALS['rlListings']->getListingTitle($value['Category_ID'], $value, $value['Listing_type']);
            $listings[$key]['url'] = $GLOBALS['reefless']->url('listing', $listings[$key], $GLOBALS['config']['lang']);
        }

        return $listings;
    }

    /**
    * Adapt features
    *
    * @param  array $field_key   - Field info
    * @param  string $features   - String containing set of items
    * @param  string $delimiter  - Delimiter sign
    *
    * @return string             - String containing set of adapted to flynax field values
    **/
    function adaptFeatures($field_info, $features, $delimiter = ',')
    {
        global $rlXmlMapping;

        $data = explode($delimiter, $features);

        $source_mapping = $field_info['Condition']
        ? $rlXmlMapping->data_formats_mapping[$field_info['Condition']]
        : $rlXmlMapping->listing_fields_mapping[$field_info['Key']];

        $out = '';
        foreach ($data as $key => $item) {
            if ($map_item = $source_mapping[$item]) {
                $out .= $map_item . $delimiter;
            }
        }

        $out = trim($out, $delimiter);

        return $out;
    }

    /**
    * function toXml
    *
    * @param array $array - data array
    */
    function toXML($array) {
        foreach ($array as $key => $value) {
            if (is_int($key)/* && is_array($value)*/) {
            } else {
                $out .= '<' . $key;
                if (is_array($value) && is_array($value['@attributes'])) {
                    foreach ($value['@attributes'] as $ak => $av) {
                        $out .=' ' . $ak . '="' . $av . '"';
                    }
                    unset($value['@attributes']);
                }
                $out .='>';
            }

            if (is_array($value)) {
                $out .= $this->toXml($value);
            } else {
                $out .= '<![CDATA[' . $value . ']]>';
            }

            if (is_int($key)/* && is_array($value)*/) {
            } else {
                $out .='</' . $key . '>';
            }
        }

        return $out;
    }
}
