
/******************************************************************************
 *
 *	PROJECT: Flynax Classifieds Software
 *	VERSION: 4.6.0
 *	LICENSE: FL7PX995723I - https://www.flynax.com/license-agreement.html
 *	PRODUCT: Auto Classifieds Script
 *	DOMAIN: autobsmllc.com
 *	FILE: MAILLER.JS
 *
 *	The software is a commercial product delivered under single, non-exclusive,
 *	non-transferable license for one domain or IP address. Therefore distribution,
 *	sale or transfer of the file in whole or in part without permission of Flynax
 *	respective owners is considered to be illegal and breach of Flynax License End
 *	User Agreement.
 *
 *	You are not allowed to remove this information from the file without permission
 *	of Flynax respective owners.
 *
 *	Flynax Classifieds Software 2023 |  All copyrights reserved.
 *
 *	https://www.flynax.com/
 *
 ******************************************************************************/

function newsletterAction($button, $email, $name, guestMode) {
   $button.off('click').click(function() {
        $button.val(lang['loading']).attr('disabled', 'true');
        var data = {
            mode: 'newsletterSubscribe',
            name: guestMode ? lang['massmailer_newsletter_guest']: $name.val(),
            email: $email.val(),
            lang: rlLang
        };

        $.getJSON(rlConfig['ajax_url'], data, function(response) {
            if (response) {
                if (response.status === 'OK' || response.status === 'WARNING') {
                    guestMode ? '' : $name.val('');
                    $email.val('');
                    $button.val($button.data('default-val')).removeAttr('disabled');
                    if (response.status === 'OK') {
                        printMessage('notice', response.data.content);
                    } else {
                        printMessage('warning', response.data.content);
                    }
                } else {
                    $button.val($button.data('default-val')).removeAttr('disabled');
                    printMessage('error', response.data.message);
                }
            } else {
                $button.val($button.data('default-val')).removeAttr('disabled');
                printMessage('warning', lang['massmailer_newsletter_no_response']);
            }
        }).fail(function() {
            $button.val($button.data('default-val')).removeAttr('disabled');
            printMessage('warning', lang['massmailer_newsletter_no_response']);
        });
    });
};
