(function($) {
    $.carousel = function(element, options){
        var self = this;
        this.options = $.extend({}, $.carousel.defaultOptions, options);

        // create function
        this.create = function() {
            var self = this;

            if ( !self.options.default_visible  ) {
                self.options.default_visible = self.options.visible;
                self.options.default_scroll = self.options.scroll;
            }

            self.animate_symbol = this.options.direction == 'ltr' ? '-' : '+';

            if ( !self.options.vertical ) {
                self._elements();
                self.checkVisible();
                self.options.value = '%';
            }
            else {
                self.options.vertical_default = true;
            }

            if ( self.options.scroll>self.options.visible ) {
                self.options.scroll = self.options.visible;
            }

            var media_query_cur = media_query;

            $(window).on('resize', function(){
                if(media_query_cur != media_query) {
                    self.destroy();
                    media_query_cur = media_query;
                }
            });

            self.init();

            self.addNextPrevActions();

            if ( self.options.auto && self.elements.count > self.options.visible) {
                $(element).hover(
                    function() {
                        self.stopSlide();
                    }, function() {

                        self.bindAutoScroll();
                    }
                );
            }
        }

        this.init = function () {
            var opts = self.options

            if (opts.vertical_default && $.inArray(opts.side_box, opts.vertical_boxes)!=-1 && media_query != "tablet") {
                opts.vertical = true;
                opts.value = 'px';
                $(element).parent().removeClass('horizontal').addClass('vertical');
            }


            if ( opts.vertical && $.inArray(opts.side_box, opts.vertical_boxes)!=-1 && media_query == "tablet"
                || $.inArray(opts.templateName, opts.template_home)!=-1 && rlPageInfo['key'] == 'home') {
                opts.vertical = false;
                opts.value = '%';
                $(element).parent().removeClass('vertical').addClass('horizontal');
            }

            self._elements();
            self.checkVisible();
            if ( opts.circular ) {
                self.circular();
            }

            self.build();

            if ( opts.auto && self.elements.count > opts.visible) {
                self.bindAutoScroll();
            }
        }

        self._elements = function () {
            var elems = this.elements = {};

            elems.curr =  0;
            elems.interval = 0;
            elems.running = false;
            elems.id = $(element).attr('id');
            elems.ul = $(element).children('ul');
            elems.li_first = elems.ul.children('li').eq(0);
            elems.items = elems.ul.children('li');
            elems.count = elems.items.length;

            return;
        }

        self.build = function () {

            if ( this.options.vertical) {
                this.vertical();
            }
            else {
                this.horizontal();
            }

            return;
        }

        self.horizontal = function () {
            elems = this.elements;
            elems.animCss=this.options.direction == 'rtl'?"margin-right":"margin-left";
            elems.sizeCss="width";
            this.checkVisible();
            elems.ul.css({'position': 'relative', height: ''});
            position = 0;

            if($.inArray(this.options.templateName, this.options.template_left_all)!=-1 && $(element).closest('.side_block').length > 0) {
                elems.items.addClass('maxWidthAuto')
            }

            elems.items.css({height: ''});
            $(element).css({height: ''});
        }

        self.vertical = function () {
            elems = this.elements;
            elems.animCss="top";
            elems.sizeCss="height";
            this.height();
            elems.divSize = elems.liSize * this.options.visible;
            elems.ulSize = elems.liSize+(this.options.number + elems.count) ;
            elems.items.css({height: elems.liRealSize});
            $(element).css(elems.sizeCss, elems.divSize+this.options.value);
            elems.ul.css(elems.sizeCss, elems.ulSize+elems.liSize+this.options.value).css(elems.animCss, 0);

            return;
        }

        self.checkVisible = function () {
            var self = this, elems = this.elements, opts = this.options, val = '', item_class = '';
            item_class = $(elems.items[0]).attr("class").split(" ");

            if ( !opts.vertical ) {
                if(($.inArray(opts.templateName, opts.template_home)!=-1 || $.inArray(opts.templateName, opts.template_all)!=-1)
                    && $(element).closest('.side_block').length > 0) {

                    switch (opts.templateName) {
                        case "auto_flatty":
                        case "boats_flatty":
                        case "pets_flatty":
                            if(media_query == 'desktop' && rlPageInfo['key'] == 'home') {
                                elems.liSize = 50;
                                opts.visible = 2;
                            }
                            else {
                                elems.liSize = 100;
                                opts.visible = 1;
                            }
                            break;
                        case "realty_flatty":
                            if(media_query == 'desktop') {
                                elems.liSize = 50;
                                opts.visible = 2;
                            }
                            else {
                                elems.liSize = 100;
                                opts.visible = 1;
                            }
                            break;
                        default:
                            elems.liSize = 100;
                            opts.visible = 1;
                            break;
                    }

                }
                else if ( $(element).closest('.side_block').length > 0  && media_query == 'desktop') {
                    elems.liSize = 100;
                    opts.visible = 1;
                }
                else {
                       
                    if (opts.templateName.indexOf("_nova") >= 0){
                        enquire.register("screen and (min-width: 1440px)", {
                            match: function(){
                                if($('body.no-sidebar').length>0) {
                                    opts.visible = 5;
                                    elems.liSize = 20;
                                }
                                else {
                                    opts.visible = 4;
                                    elems.liSize = 25;
                                }
                            }
                        }).register("screen  and (max-width: 1439px)", {
                            match: function(){
                                self.rebuildVisible(item_class);
                            }
                        });

                    }
                    else {
                        self.rebuildVisible(item_class);
                    }
                }
            }
            else {
                if( opts.visible > elems.count ) {
                    opts.visible = elems.count;
                }
            }

            if ( opts.scroll >= opts.visible )  {
                opts.scroll = opts.visible;
            }
            else
            {
                opts.scroll = opts.default_scroll;
            }

            
            return;
        }

        self.rebuildVisible = function(item_class) {
            var elems = this.elements,opts = this.options;
            var bootstr = self.parseBootrstrap(item_class);
            if ( media_query == 'desktop' && large_desktop && bootstr['lg'] ) {
                val = bootstr['lg'];
            }
            else if ( media_query == 'desktop' && bootstr['md'] ) {
                val = bootstr['md'];
            }
            else if (( media_query == 'desktop' || media_query == 'tablet') && bootstr['sm'] ) {
                val = bootstr['sm'];
            }
            else if ( media_query == 'mobile' ) {
                if ( bootstr['xs'] ) {
                    val = bootstr['xs'];
                }
                else {
                    val = 12;
                }
            }
            elems.liSize = 100 / ( 12 / val );
            opts.visible = 100 / elems.liSize;
        }

        self.parseBootrstrap = function(val) {
            var a = new Array();
            for(var i=0; i < val.length; i++) {
                col = val[i].split("-");
                if(col[0]=='col') {
                    a[col[1]] = col[2];
                }
            }

            return a;
        }

        self.height = function () {
            var elems = this.elements;
            max_height = '';
            for ( var i = 0; i < this.options.count; i++ ) {
                this.elements.items.eq(i).removeAttr('style');
                if ( max_height < this.elements.items.eq(i).outerHeight(true) ) {
                    max_height = this.elements.items.eq(i).outerHeight(true);
                    elems.liRealSize = this.elements.items.eq(i).height();
                }
            }
            elems.liSize = max_height;

            return;
        }

        self.circular = function () {
            if(this.elements.count < this.options.visible && !this.options.circular_start)  {
                return;
            }
            this.elements.ul.append(this.elements.items.slice(0, this.options.count).clone());
            this.options.circular_start = true;
            this._elements();

            return;
        }

        self.addNextPrevActions = function () {

            if( this.elements.count < this.options.visible )  {
                return;
            }

            if ( !this.options.btnPrev || !this.options.btnNext ) {
                return;
            }

            var self = this,
                elems = this.elements,
                opts = this.options;

            $(element).before('<div class="'+this.options.btnNext.replace(".", "")+' next" ></div><div class="'+this.options.btnPrev.replace(".", "")+' prev" ></div>');

            if ( $(element).closest('.ling_top_block').length > 0 ) {
                $(this.options.btnNext).css('right', '-20px');
                $(this.options.btnPrev).css('left', '-20px');
            }

            $(this.options.btnNext).on('click', function() {
                self.next();
            });

            $(this.options.btnPrev).on('click', function() {
                self.prev();
            });

            return;
        }

        self.next = function () {
            if(this.options.loading) {
                return;
            }

            this.options.loading = true;

            if ( this.options.auto ) {
                this.iterval();
            }
            return this.slide(this.elements.curr, 'next');
        }

        self.prev = function () {
            if(this.options.loading) {
                return;
            }

            this.options.loading = true;

            if ( this.options.auto ) {
                this.iterval();
            }
            return this.slide(this.elements.curr, 'prev');
        }

        self.iterval = function () {

            clearInterval(self.elements.interval);
            this.bindAutoScroll();
        }

        self.bindAutoScroll = function() {
            var self = this, elems = this.elements, opts = this.options;

            self.elements.interval = setInterval(function() {
                self.slide(elems.curr, 'next');

            }, opts.auto);

            return;
        }

        self.stopSlide = function() {

            clearInterval(self.elements.interval);

            return;
        }

        self.beforeStart = function() {
            var self = this, elems = this.elements, opts = this.options;

            if ( elems.count != elems.ul.children('li').length ) {
                elems.items = elems.ul.children('li');
                elems.count = elems.items.length;

                if ( opts.vertical ) {
                    elems.items.css({height: elems.liRealSize});
                }
                else {
                    new_margin =  (elems.divSize - elems.items.width()*opts.visible) / (opts.visible-1);
                    margin_left = opts.direction == 'rtl' ? new_margin : 0;
                    margin_right = opts.direction != 'rtl' ? new_margin : 0;
                }
            }

            return;
        }

        self.afterLoadAjax  = function( block_key, add_count ) {
            var self = this, elems = this.elements, opts = this.options;

            if ( block_key ) {
                if ( currencyConverter.config.currency != false ) {
                    if ( typeof($.convertPrice) == 'function' )
                    {
                        $('#carousel_' + block_key +' .price_tag > *').convertPrice();
                    }
                    else {
                        currencyConverter.convertFeatured(block_key);
                    }
                }
            }

            flFavoritesHandler();

            if ( !opts.circular ) {
                self.checkVisible();
                if(opts.scroll > add_count) {
                    new_curr = opts.scroll - add_count;
                    elems.curr = elems.curr - new_curr;
                }
            }

            self.beforeStart();

            if ( typeof caroselCallback == 'function' ) {
               caroselCallback();
            }

            self.animate();

        return;
        }

        self.slide = function (to, direction) {
            var self = this,
                elems = this.elements,
                o = this.options;

            if ( !elems.running ) {
                curr = direction=='next' ? to+this.options.scroll : to-this.options.scroll;

                if ( o.circular ) {
                    if ( curr<=0 ) {
                        // If first, then goto last
                        if ( to==0 ) {
                            if ((o.direction=='ltr' && direction=='prev' && rlCarousel[elems.id] > 0 )|| (o.direction=='rtl' && direction=='prev' && rlCarousel[elems.id] > 0)) {
                                self.options.loading = false;
                                return;
                            }
                            else {
                                if ( o.vertical ) {
                                    elems.ul.css(elems.animCss, -((elems.count-o.count)*elems.liSize)+this.options.value);
                                }
                                else {
                                    elems.ul.css({
                                        transform:  'translateX(' + (self.animate_symbol + (elems.count-o.count)*elems.liSize)+this.options.value+ ')'
                                    }).addClass('transition-none');
                                }
                                // If "scroll" > 1, then the "to" might not be equal to the condition; it can be lesser depending on the number of elements.
                                curr = elems.count-o.count-o.scroll;
                            }
                        }
                        else if ( curr<0 ) {
                            curr = 0;
                        }

                    }
                    else if ( curr>=elems.count-o.count ) {
                        if ( to==elems.count-o.visible ) {
                            // If last, then goto first
                            if ( o.vertical ) {
                                elems.ul.css(elems.animCss, -(o.count-o.visible)*elems.liSize+this.options.value);
                            }
                            else {
                                elems.ul.css({
                                    transform:  'translateX(' + (self.animate_symbol + (o.count-o.visible)*elems.liSize + this.options.value) + ')'
                                }).addClass('transition-none');
                            }
                            // If "scroll" > 1, then the "to" might not be equal to the condition; it can be greater depending on the number of elements.
                            curr = o.count-o.visible+o.scroll;
                        }
                        else if ( curr+o.visible > elems.count ) {
                            curr =(elems.count-o.visible);
                        }
                    }
                }
                else {
                    // If non-circular and to points to first or last, we just return.
                    if ( curr<0 ) {
                        curr = 0;
                    }
                    else if(curr>elems.count-o.visible && rlCarousel[elems.id] == 0) {
                        curr = elems.count-o.visible;
                    }
                    else {
                        curr = curr;
                    }

                }
                elems.curr = curr;

                if ( rlCarousel[elems.id] > 0 ) {
                    if ( o.circular ) {
                        carent_id = elems.count-o.count-1;
                    }
                    else {
                        carent_id = elems.count-1;
                    }

                    elems.running = true;

                    $.getJSON(rlConfig['ajax_url'],
                        {
                            item: 'listing_carousel',
                            lang: rlLang,
                            limit: o.scroll,
                            options: o.options,
                            number: rlCarousel[elems.id],
                            price_tag: o.priceTag,
                            side_bar_exists: o.side_bar_exists,
                            page_key: rlPageInfo['key']
                        }, function(response) {
                            if (response.status == 'ok') {
                                $(element).find("ul.featured>li").eq(carent_id).after(response.results);
                                rlCarousel[elems.id] = rlCarousel[elems.id] - response.count;
                            }
                            else {
                                rlCarousel[elems.id] = 0;
                            }
                            self.afterLoadAjax(response.block_key, response.count);
                    });
                }
                else {
                    elems.running = true;
                    self.animate();
                }
            }
        }

        self.animate = function(){
            var self = this, elems = this.elements, o = this.options;
            var first_el = elems.ul.children().eq(0);
            if ( this.options.vertical ) {
                elems.ul.animate({ top: -(elems.curr*elems.liSize) }, o.speed, o.easing,
                    function() {
                        elems.running = false;
                        self.options.loading = false;
                    }
                );
            }
            else {
                setTimeout(function() {
                    elems.ul.removeClass("transition-none");
                    elems.ul.css({
                        transform: 'translateX(' + ( self.animate_symbol + (elems.curr*elems.liSize) + self.options.value) + ')',
                    });
                    elems.running = false;
                    self.options.loading = false;
                }, 1000);

            }
           
        }

        self.destroy = function () {
            var self = this, elems = this.elements, o = this.options;
            this.stopSlide();

            if (!this.options.vertical) {
                if(o.circular_start) {
                    var fake_el = elems.count - o.count;

                    o.count = fake_el;
                    for ( var i = fake_el; i < elems.count; i++ ) {
                        $(this.elements.items.eq(i)).remove();
                    }
                    o.circular_start = false;

                }
                elems.li_first.attr('style', '');
            }

            elems.curr = 0;
            this.init();
        }

        self.create();
    }

    $.carousel.defaultOptions = {
        loading: false,
        btnPrev: null,
        btnNext: null,
        auto: null,
        speed: 1000,
        speedSec: 1,
        direction: 'ltr',
        animate_symbol: '-',
        value: 'px',
        vertical: false,
        vertical_boxes: ['right','left'],
        template_home: ['auto_flatty','boats_flatty','pets_flatty','pets_flatty'],
        template_all: ['escort_sun_cocktails_wide','general_simple_wide','realty_flatty'],
        template_left_all: ['escort_flatty','escort_velvet_flatty','general_flatty'],
        circular: false,
        circular_start: false,
        visible: 4,
        start: 0,
        scroll: 1,
        number: 0,
        count: 0
    };

    $.fn.carousel = function(options){
        return this.each(function(){
            (new $.carousel(this, options));
        });
    };
}(jQuery));
