<?php


/******************************************************************************
 *
 *	PROJECT: Flynax Classifieds Software
 *	VERSION: 4.7.0
 *	LICENSE: FL7PX995723I - https://www.flynax.com/license-agreement.html
 *	PRODUCT: Auto Classifieds Script
 *	DOMAIN: autobsmllc.com
 *	FILE: RLLISTINGSCAROUSEL.CLASS.PHP
 *
 *	The software is a commercial product delivered under single, non-exclusive,
 *	non-transferable license for one domain or IP address. Therefore distribution,
 *	sale or transfer of the file in whole or in part without permission of Flynax
 *	respective owners is considered to be illegal and breach of Flynax License End
 *	User Agreement.
 *
 *	You are not allowed to remove this information from the file without permission
 *	of Flynax respective owners.
 *
 *	Flynax Classifieds Software 2023 |  All copyrights reserved.
 *
 *	https://www.flynax.com/
 *
 ******************************************************************************/

class rlListingsCarousel extends Flynax\Abstracts\AbstractPlugin implements Flynax\Interfaces\PluginInterface
{
    /**
     * Plugin installer
     * @since 3.3.0
     **/
    public function install()
    {

        // create table
        $sql = "
            CREATE TABLE `" . RL_DBPREFIX . "listings_carousel` (
              `ID` int(11) NOT NULL AUTO_INCREMENT,
              `Direction` enum('vertical','horizontal') NOT NULL DEFAULT 'horizontal',
              `Block_IDs` varchar(255) NOT NULL,
              `Number` int(10) NOT NULL,
              `Delay` int(10) NOT NULL,
              `Per_slide` int(10) NOT NULL,
              `Visible` int(10) NOT NULL,
              `Round` enum('0','1') NOT NULL DEFAULT '1',
              `Status` varchar(10) NOT NULL,
              PRIMARY KEY (`ID`)
            ) DEFAULT CHARSET=utf8;";

        $GLOBALS['rlDb']->query($sql);

        $GLOBALS['rlDb']->query("UPDATE `" . RL_DBPREFIX . "hooks` SET `Class` = '' WHERE `Plugin` = 'listings_carousel' AND `Name` = 'init';");
    }

    /**
     * Plugin un-installer
     * @since 3.3.0
     **/
    public function uninstall()
    {
        // DROP TABLE
        $GLOBALS['rlDb']->query("DROP TABLE IF EXISTS `" . RL_DBPREFIX . "listings_carousel`");
    }

    /**
     * @hook staticDataRegister
     * set css and js files for new version(4.5 and more)
     **/
    public function hookStaticDataRegister()
    {
        $GLOBALS['rlStatic']->addBoxJS(RL_PLUGINS_URL . 'listings_carousel/static/carousel.js', 'listings_carousel', true);
        $GLOBALS['rlStatic']->addBoxFooterCSS(RL_PLUGINS_URL . 'listings_carousel/static/carousel.css', 'listings_carousel', true);
    }

    /**
     * @hook ajaxRequest
     **/
    public function hookAjaxRequest(&$out, $request_mode, $request_item, $request_lang)
    {
        if ($request_item == 'listing_carousel') {
            $lang = $GLOBALS['rlLang']->getLangBySide('frontEnd', $request_lang);
            $out = $this->loadListings(
                $_REQUEST['limit'],
                $_REQUEST['options'],
                $_REQUEST['number'],
                $_REQUEST['price_tag'],
                $_REQUEST['side_bar_exists'],
                $_REQUEST['page_key']
            );
            $out['status'] = $out['count'] >= 1 && $out['results'] ? 'ok' : 'no';
        }
    }

    /**
     * @hook Init
     * @since 3.3.0
     **/
    public function hookInit()
    {}

    /**
     * @hook specialBlock
     * @since 3.3.0
     */
    public function hookSpecialBlock()
    {
        global $carousel_options;
        if ($carousel_options) {
            $this->changeContentBlock($carousel_options);
        }
    }

    /**
     * @hook listingsAfterSelectFeatured
     * @since 3.3.0
     **/
    public function hookListingsAfterSelectFeatured($sql, $block_key, $listings)
    {
        global $blocks, $carousel_options;
        $id = $blocks[$block_key]['ID'];

        foreach ($listings as $key => $val) {
            if ($carousel_options[$id]) {
                $_SESSION['carousel'][$block_key][] = $val['ID'];
            }
            $_SESSION['carousel']['all_ids'][] = $val['ID'];
        }
    }

    /**
     * @hook listings Modify Where Featured
     * @since 3.3.0
     **/
    public function hookListingsModifyWhereFeatured($sql, $block_key, &$limit, $start)
    {
        global $blocks, $carousel_options;
        $id = $blocks[$block_key]['ID'];
        if ($carousel_options[$id]) {
            $limit = $carousel_options[$id]['Visible'] == 0 ? 5 : $carousel_options[$id]['Visible'];
        }
    }

    /**
     * Update configuration for carousel
     **/
    public function updateCarouselBlock()
    {
        global $rlDb;

        $box = $rlDb->getAll("SELECT * FROM `" . RL_DBPREFIX . "listings_carousel` WHERE `Status` = 'active' ");

        $content = 'global $rlSmarty, $carousel_options;';
        $content .= ' if ( !$_REQUEST["xjxfun"] && !defined("AJAX_FILE")) {unset($_SESSION["carousel"]);}';

        if ($box) {
            $content .= '$carousel_options = array(';

            foreach ($box as $key => $item) {

                $block_ids = explode(',', $item['Block_IDs']);
                foreach ($block_ids as $keyId => $itemId) {
                    if ($itemId) {
                        $content .= (int) $itemId . '=> array( ';
                        $content .= '"Direction" => "' . $item['Direction'] . '",';
                        $content .= '"Number" => "' . $item['Number'] . '",';
                        $content .= '"Delay" => "' . $item['Delay'] . '",';
                        $content .= '"Per_slide" => "' . $item['Per_slide'] . '",';
                        $content .= '"Visible" => "' . $item['Visible'] . '",';
                        $content .= '"Round" => "' . $item['Round'] . '"';
                        $content .= '),';
                    }
                }
            }
            $content = substr($content, 0, -1);
            $content .= ');';
        }

        $content .= '$rlSmarty->assign("carousel_options", $carousel_options);';

        if ($rlDb->query("UPDATE  `" . RL_DBPREFIX . "hooks` SET `Class` = '', `Code` = '{$content}' WHERE `Name` = 'init' AND `Plugin` = 'listings_carousel'  LIMIT 1;")) {
            return true;
        }
    }

    /**
     * Change content block for carousel
     *
     * @param  array $contents - options of carousel
     *
     * @return array           - adapted listings data
     **/
    public function changeContentBlock($contents = false)
    {
        global $carousel_options, $blocks, $tpl_settings, $page_info, $config;

        $array_templates = array("auto_flatty");

        if ($_REQUEST["item"] != "listing_carousel") {
            $_SESSION['carousel']['all_ids'] = $GLOBALS['rlListings']->selectedIDs;
        }

        if (version_compare($config['rl_version'], '4.7.0') >= 0) {
            if ($tpl_settings['home_page_gallery'] && $config['home_gallery_box'] && $page_info['Key'] == 'home') {
                $home_gallery_key = $config['home_gallery_box'];
            }
        }
        else {
            if (($tpl_settings['home_page_gallery'] || in_array($tpl_settings['name'], $array_templates)) && $page_info['Key'] == 'home') {
                $sql = "SELECT `Key` FROM `" . RL_DBPREFIX . "blocks` ";
                $sql .= "WHERE `Status` = 'active' AND `Key` RLIKE 'ltfb_(.*)$' ";
                $sql .= "AND (FIND_IN_SET( '{$page_info['ID']}', `Page_ID` ) > '0' OR `Sticky` = '1')";
                $sql .= "AND FIND_IN_SET( `Side`, 'top,middle,bottom') ORDER BY FIND_IN_SET( `Side`, 'top,middle,bottom'), `Position` LIMIT 1";
                $first_featured = $GLOBALS['rlDb']->getRow($sql);
                $home_gallery_key = $first_featured['Key'] ? $first_featured['Key'] : "";
            }
        }
        
        foreach ($blocks as $sKey => $sVal) {
            foreach ($contents as $key => $val) {
                if ($sVal['ID'] == $key) {
                    if ($blocks[$sKey]['Type'] != 'smarty') {
                        $option = $carousel_options[$blocks[$sKey]['ID']];
                        preg_match('/getListings\(\s"([\w,]*)",\s"(\w*)",\s"([0-9]*)",\s"([0-9]*)",\s"([0-9]*?)"\s\);/', $sVal['Content'], $matches);
                        
                        /* get replace type and listings */
                        $content_block = str_replace(array('"listings_box",', '"listings_box" .', 'listings_box.block'), array('"listings_carousel",', '"listings_carousel" .', 'carousel.block'), $sVal['Content']);
                        $listings_name = "listings_carousel";
                        $box_name = "carousel.block.tpl";
                        $visible = $matches[3] < 5 ? 5 : $matches[3];

                        $content_block = 'global $rlSmarty, $reefless;
							if($_REQUEST["page"] == "404") {return;}
							$reefless->loadClass("ListingsBox", null, "listings_box");
							$listings_box = $GLOBALS["rlListingsBox"]->getListings( "' . $matches[1] . '", "' . $matches[2] . '", ' . $visible . ', "' . $matches[4] . '", "' . $matches[5] . '" );
							foreach($listings_box as $key => $val)
							{
								$ids[] = $val["ID"];
								$_SESSION["carousel"]["all_ids"][] = $val["ID"];
							}
							$_SESSION["carousel"]["' . $sVal['Key'] . '"] = $ids;
							$rlSmarty->assign_by_ref("' . $listings_name . '", $listings_box);
							$rlSmarty->assign("type", "listings");
							$rlSmarty->display(RL_PLUGINS . "listings_carousel" . RL_DS . "' . $box_name . '" );';

                        $blocks[$sKey]['Content'] = $content_block;
                        $blocks[$sKey]['Plugin'] = "listings_carousel";
                        $blocks[$sKey]['options'] = "listing_box|" . $blocks[$sKey]['Key'] . "|" . $matches[1] . "|" . $matches[2] . "|" . $matches[4] . "|" . $matches[5];

                    } else {
                        if ($home_gallery_key != $sVal['Key']) {
                            /* get field/value */
                            preg_match("/listings=(.*)\s+type='(\w+)'(\s+field='(\w+)')?(\s+value='(\w+)')?/", $sVal['Content'], $matches);
                            $arange_fields = $matches['3'] || $matches['5'] ? $matches['3'] . " " . $matches['5'] : "";

                            $blocks[$sKey]['Content'] = '{include file=$smarty.const.RL_PLUGINS|cat:"listings_carousel"|cat:$smarty.const.RL_DS|cat:"carousel.block.tpl" listings_carousel=' . $matches[1] . ' type="' . $matches[2] . '" ' . $arange_fields . '}';

                            $blocks[$sKey]['Plugin'] = "listings_carousel";
                            $blocks[$sKey]['options'] = "featured|" . $blocks[$sKey]['Key'] . "|" . $matches[2] . "|" . $matches[4] . "|" . $matches[6];
                        }
                    }
                }
            }
        }
        
        $GLOBALS['rlCommon']->defineBlocksExist($blocks);
    }

    /**
     * Load  listings
     *
     * @param int     $limit           -  limit
     * @param string  $options         -  options
     * @param int     $number          -  max listings
     * @param bool    $priceTag        -  price tag
     * @param bool    $side_bar_exists -  price tag
     * @param string  $page_info_key   -  price tag
     *
     **/
    public function loadListings($limit = 1, $options = false, $number = false, $priceTag = false, $side_bar_exists = false, $page_info_key = false)
    {
        global $rlListings, $rlSmarty, $reefless, $config, $page_info, $tpl_settings;

        // define tpl settings
        if (!$tpl_settings) {
            require_once RL_ROOT . 'templates' . RL_DS . $config['template'] . RL_DS . 'settings.tpl.php';
        }

        $rlSmarty->register_function('rlHook', array('rlHook', 'load'));

        $GLOBALS['rlValid']->sql($options);
        $options = explode('|', $options);

        $GLOBALS['rlHook']->load('featuredTop');

        // if limit more number
        if ($number - $limit < 0) {
            $limit = $number;
        }

        //get listing types
        $listing_types = $GLOBALS['rlListingTypes']->types;

        // get listings by type
        if ($options[0] == 'featured') {
            $rlListings->selectedIDs = $_SESSION['carousel']['all_ids'];
            $listings = $rlListings->getFeatured($options[2], $limit, $options[3], $options[4]);
        } else {
            // get listing box
            $reefless->loadClass('ListingsBox', null, 'listings_box');
            if ($options[4]) {
                $rlListings->selectedIDs = $_SESSION['carousel']['all_ids'];
            } else {
                $rlListings->selectedIDs = $_SESSION['carousel'][$options[1]];
            }

            $listings = $GLOBALS["rlListingsBox"]->getListings($options[2], $options[3], $limit, 1, $options[5]);
        }
        // define page info
        if ($page_info_key && !$page_info) {
            $sql = "SELECT * FROM `" . RL_DBPREFIX . "pages` WHERE `Key` = '{$page_info_key}' AND `Status` = 'active' LIMIT 1";
            $page_info = $GLOBALS['rlDb']->getRow($sql);
        }

        if ($listings) {
            $rlSmarty->assign('rlTplBase', RL_URL_HOME . 'templates/' . $config['template'] . '/');
            $html_content = "";
            // add new listings
            foreach ($listings as $key => $listing) {
                if ($options[0] != 'featured') {
                    $_SESSION['carousel'][$options[1]][] = $listing['ID'];
                }
                if (!in_array($listing['ID'], $_SESSION['carousel']['all_ids'])) {
                    $_SESSION['carousel']['all_ids'][] = $listing['ID'];
                }

                // assign listing, type and page key
                $listing_type = $listing['Listing_type'];
                $page_key = $listing_types[$listing_type]['Page_key'];
                $rlSmarty->assign('side_bar_exists', $side_bar_exists);
                $rlSmarty->assign('type', $listing_type);
                $rlSmarty->assign('page_key', $page_key);
                $rlSmarty->assign('block', $plugin = $GLOBALS['rlDb']->fetch("*", array('Status' => 'active', 'Key' => $options[1]), null, 1, 'blocks', 'row'));
                $rlSmarty->assign('featured_listing', $listing);

                $tpl = 'blocks' . RL_DS . 'featured_item.tpl';
                $html_content .= $rlSmarty->fetch($tpl, null, null, false);
            }
        }

        $content_listings['block_key'] = "";

        if ($GLOBALS['plugins']['currencyConverter']) {
            $content_listings['block_key'] = $options[1];
        }
        $content_listings['count'] = count($listings);
        $content_listings['results'] = $html_content;

        return $content_listings;
    }

    /**
     * Remove listing carousel
     *
     * @hook apAjaxRequest
     **/
    public function hookApAjaxRequest()
    {
        $item = $GLOBALS['rlValid']->xSql($_REQUEST['item']);
        switch ($item) {
            case 'deleteListingsCarousel':
                $id = (int) $_REQUEST['id'];
                // delete box
                $GLOBALS['rlDb']->query("DELETE FROM `" . RL_DBPREFIX . "listings_carousel` WHERE `ID` = '{$id}' LIMIT 1");

                // update carousel boxs
                $this->updateCarouselBlock();
                $GLOBALS['out']['status'] = "ok";
                $GLOBALS['out']['message'] = $GLOBALS['lang']['block_deleted'];
                break;
        }
    }

    /**
     * Update process of the plugin (copy from core)
     * @param string $version
     */
    public function update($version)
    {
        $version_method = 'update' . (int) str_replace('.', '', $version);
        if (method_exists($this, $version_method)) {
            $this->$version_method();
        }
    }

    /**
     * Update to 3.3.0 version
     */
    public function update330()
    {
        global $rlDb;

        // Set class to plugin
        $rlDb->query("UPDATE  `{db_prefix}plugins` SET `Class` = 'ListingsCarousel' WHERE `Key` = 'listings_carousel';");

        // Update Carousel options
        $this->updateCarouselBlock();

        // Remove hook
        $rlDb->query("
            DELETE FROM `{db_prefix}hooks`
            WHERE `Plugin` = 'listings_carousel'
            AND `Name` = 'tplHeader'
        ");

        // Remove legacy files
        $files_to_be_removed = array(
            'static/carousel_44.css',
            'static/carousel_44.js',
            'static/carousel_45.css',
            'static/carousel_45.js',
            'carousel.listing.tpl',
            'carousel.block_44.tpl',
        );
        foreach ($files_to_be_removed as $file) {
            unlink(RL_PLUGINS . 'listings_carousel/' . $file);
        }
    }

    /**
     * @deprecated 3.3.0
     */
    public function ajaxDeleteCarouselBox()
    {}

    /**
     * @deprecated 3.3.0
     */
    public function ajaxLoadListings($id = false, $limit = 1, $options = false, $number = false, $priceTag = false)
    {}

    /**
     * @deprecated 3.3.0
     */
    public function ajaxCarouselListings($limit = 1, $options = false, $number = false, $priceTag = false, $side_bar_exists = false)
    {}
}
