<?php


/******************************************************************************
 *
 *	PROJECT: Flynax Classifieds Software
 *	VERSION: 4.7.0
 *	LICENSE: FL7PX995723I - https://www.flynax.com/license-agreement.html
 *	PRODUCT: Auto Classifieds Script
 *	DOMAIN: autobsmllc.com
 *	FILE: LISTINGS_CAROUSEL.INC.PHP
 *
 *	The software is a commercial product delivered under single, non-exclusive,
 *	non-transferable license for one domain or IP address. Therefore distribution,
 *	sale or transfer of the file in whole or in part without permission of Flynax
 *	respective owners is considered to be illegal and breach of Flynax License End
 *	User Agreement.
 *
 *	You are not allowed to remove this information from the file without permission
 *	of Flynax respective owners.
 *
 *	Flynax Classifieds Software 2023 |  All copyrights reserved.
 *
 *	https://www.flynax.com/
 *
 ******************************************************************************/

if ($_GET['q'] == 'ext') {
    // system config
    require_once '../../../includes/config.inc.php';
    require_once RL_ADMIN_CONTROL . 'ext_header.inc.php';
    require_once RL_LIBS . 'system.lib.php';

    if ($_GET['action'] == 'update') {
        $reefless->loadClass('Actions');
        $reefless->loadClass('ListingsCarousel', null, 'listings_carousel');

        $field = $rlValid->xSql($_GET['field']);
        $value = $rlValid->xSql(nl2br($_GET['value']));
        $key = $rlValid->xSql($_GET['key']);
        $id = (int) $_GET['id'];

        $updateData = array(
            'fields' => array(
                $field => $value,
            ),
            'where' => array(
                'ID' => $id,
            ),
        );
        $rlActions->updateOne($updateData, 'listings_carousel');
        $rlListingsCarousel->updateCarouselBlock();
        exit;
    }

    // data read
    $limit = (int) $_GET['limit'];
    $start = (int) $_GET['start'];

    $sql = "SELECT SQL_CALC_FOUND_ROWS DISTINCT * ";
    $sql .= "FROM `" . RL_DBPREFIX . "listings_carousel` ";
    $sql .= "LIMIT {$start}, {$limit}";
    $data = $rlDb->getAll($sql);

    $count = $rlDb->getRow("SELECT FOUND_ROWS() AS `count`");

    // select box
    $sql = "SELECT `ID`,`Key` FROM `" . RL_DBPREFIX . "blocks` WHERE `Status` != 'trash' AND ( `Key` RLIKE 'listing_box_(.*)$'  OR `Key` RLIKE 'ltfb_(.*)$' ) ";
    $box = $rlDb->getAll($sql);
    foreach ($box as $key => $val) {
        $block[$val['ID']] = 'blocks+name+' . $val['Key'];
    }

    foreach ($data as $key => $value) {
        // add box name
        $box_ids = explode(',', $data[$key]['Block_IDs']);
        foreach ($box_ids as $idKey => $idVal) {
            $data[$key]['Assigned_boxes'] .= $rlLang->getPhrase($block[$idVal], null, null, true) . ', ';
        }
        $data[$key]['Assigned_boxes'] = substr($data[$key]['Assigned_boxes'], 0, -2);

        $data[$key]['Direction'] = $GLOBALS['lang']['listings_carousel_' . $data[$key]['Direction']];
        $data[$key]['Status'] = $GLOBALS['lang'][$data[$key]['Status']];
    }

    $output['total'] = $count['count'];
    $output['data'] = $data;

    echo json_encode($output);
    unset($output);
} else {
    if (version_compare($GLOBALS['config']['rl_version'], '4.4.1') >= 0) {
        $carousel_new = true;
        $rlSmarty->assign_by_ref('carousel_new', $carousel_new);
    }

    $reefless->loadClass('ListingsCarousel', null, 'listings_carousel');

    $sql = "SELECT `T1`.`ID`,`T1`.`Side`,`T1`.`Key`, if(`T2`.`ID`, 1,0) AS `disabled`, `T2`.`ID` AS `Carousel_ID` ";
    $sql .= "FROM `" . RL_DBPREFIX . "blocks` AS `T1` ";
    $sql .= "LEFT JOIN `" . RL_DBPREFIX . "listings_carousel` AS `T2` ON FIND_IN_SET(`T1`.`ID`, `T2`.`Block_IDs`) ";
    $sql .= "WHERE `T1`.`Status` != 'trash' AND ( `T1`.`Key` RLIKE 'listing_box_(.*)$'  OR `T1`.`Key` RLIKE 'ltfb_(.*)$' ) ";
    $box = $rlDb->getAll($sql);

    $rlSmarty->assign_by_ref('box', $box);

    if ($_GET['action'] == 'add' || $_GET['action'] == 'edit') {
        $id = $rlValid->xSql($_GET['id']);
        $carousel_info = $rlDb->fetch('*', array('ID' => $id), null, 1, 'listings_carousel', 'row');

        // add bread crumps
        if ($_GET['action'] == 'add') {
            $bcAStep[] = array('name' => $lang['add']);
        } else if ($_GET['action'] == 'edit') {
            $bcAStep[] = array('name' => $lang['edit']);
        }

        if ($_GET['action'] == 'edit' && !$_POST['fromPost']) {
            $_POST['id'] = $carousel_info['ID'];
            $_POST['status'] = $carousel_info['Status'];
            $_POST['direction'] = $carousel_info['Direction'];
            $_POST['number'] = $carousel_info['Number'];
            $_POST['delay'] = $carousel_info['Delay'];
            $_POST['per_slide'] = $carousel_info['Per_slide'];
            $_POST['visible'] = $carousel_info['Visible'];
            $_POST['round'] = $carousel_info['Round'];
            $_POST['box'] = explode(',', $carousel_info['Block_IDs']);

        }
        if (isset($_POST['submit'])) {
            $errors = array();

            /* check numeric */
            $f_box = $_POST['box'];
            if (empty($f_box)) {
                $errors[] = str_replace('{field}', "<b>" . $lang['listings_carousel_box'] . "</b>", $lang['notice_field_empty']);
                $error_fields[] = "box";
            }

            /* check number */
            $f_number = $_POST['number'];
            if (empty($f_number)) {
                $errors[] = str_replace('{field}', "<b>" . $lang['listings_carousel_number'] . "</b>", $lang['notice_field_empty']);
                $error_fields[] = "number";
            }

            /* check delay */
            $f_delay = $_POST['delay'];
            if (empty($f_delay)) {
                $errors[] = str_replace('{field}', "<b>" . $lang['listings_carousel_delay'] . "</b>", $lang['notice_field_empty']);
                $error_fields[] = "delay";
            }

            /* check per_slide */
            $f_per_slide = $_POST['per_slide'];
            if (empty($f_per_slide)) {
                $errors[] = str_replace('{field}', "<b>" . $lang['listings_carousel_per_slide'] . "</b>", $lang['notice_field_empty']);
                $error_fields[] = "per_slide";
            }
            /* check numeric */
            $f_visible = $_POST['visible'];
            if (!$carousel_new || $_POST['direction'] == 'vertical') {
                if (empty($f_visible)) {
                    $errors[] = str_replace('{field}', "<b>" . $lang['listings_carousel_visible'] . "</b>", $lang['notice_field_empty']);
                    $error_fields[] = "visible";
                }
            }

            if (!empty($errors)) {
                $rlSmarty->assign_by_ref('errors', $errors);
            } else {
                /* add/edit action */
                if ($_GET['action'] == 'add') {
                    // write main, block information
                    $data = array(
                        'Direction' => $_POST['direction'],
                        'Block_IDs' => implode(',', $f_box),
                        'Number' => $f_number,
                        'Delay' => $f_delay,
                        'Per_slide' => $f_per_slide,
                        'Visible' => $f_visible,
                        'Round' => empty($_POST['round']) ? 0 : 1,
                        'Status' => $_POST['status'],
                    );

                    if ($action = $rlActions->insertOne($data, 'listings_carousel')) {
                        $message = $lang['listings_carousel_block_added'];
                        $aUrl = array("controller" => $controller);
                    } else {
                        trigger_error("Can't add new block (MYSQL problems)", E_WARNING);
                        $rlDebug->logger("Can't add new block (MYSQL problems)");
                    }
                } elseif ($_GET['action'] == 'edit') {
                    $data_block = array(
                        'fields' => array(
                            'Direction' => $_POST['direction'],
                            'Block_IDs' => implode(',', $f_box),
                            'Number' => $f_number,
                            'Delay' => $f_delay,
                            'Per_slide' => $f_per_slide,
                            'Visible' => $f_visible,
                            'Round' => empty($_POST['round']) ? 0 : 1,
                            'Status' => $_POST['status'],
                        ),
                        'where' => array('ID' => $_POST['id']),
                    );
                    if ($action = $GLOBALS['rlActions']->updateOne($data_block, 'listings_carousel')) {
                        $message = $lang['listings_carousel_block_edited'];
                        $aUrl = array("controller" => $controller);
                    }
                }
                if ($action) {
                    $rlListingsCarousel->updateCarouselBlock();
                    $reefless->loadClass('Notice');
                    $rlNotice->saveNotice($message);
                    $reefless->redirect($aUrl);
                }
            }
        }

    }
}
