<?php

/******************************************************************************
 *
 *	PROJECT: Flynax Classifieds Software
 *	VERSION: 4.8.2
 *	LICENSE: FL7PX995723I - https://www.flynax.com/license-agreement.html
 *	PRODUCT: Auto Classifieds Script
 *	DOMAIN: autobsm-llc.com
 *	FILE: EXPORT.PHP
 *
 *	The software is a commercial product delivered under single, non-exclusive,
 *	non-transferable license for one domain or IP address. Therefore distribution,
 *	sale or transfer of the file in whole or in part without permission of Flynax
 *	respective owners is considered to be illegal and breach of Flynax License End
 *	User Agreement.
 *
 *	You are not allowed to remove this information from the file without permission
 *	of Flynax respective owners.
 *
 *	Flynax Classifieds Software 2024 |  All copyrights reserved.
 *
 *	https://www.flynax.com/
 *
 ******************************************************************************/

require_once dirname(dirname(__DIR__)) . '/includes/config.inc.php';

$filename = RL_CACHE . "xml_" . md5(serialize($_GET));
if (is_file($filename)) {
    $fmtime = filemtime($filename);
}

$fmtime = false;
$expiration_time = 600;

if (!$fmtime || $fmtime + $expiration_time > time()) {
    require_once('control.inc.php');

    define('RL_LANG_CODE', $config['lang']);

    $lang = $rlLang->getLangBySide('frontEnd', $config['lang']);
    $format = $rlValid->xSql($_GET['format']);
    $format_info = $rlDb->fetch("*", array("Key" => $format), null, null, "xml_formats", "row");

    if (!$format_info) {
        header("HTTP/1.0 404 Not Found");
        echo $lang['error_404'];
        exit;
    } else {
        $total_limit = (int)$_GET['limit'] != 0 ? (int)$_GET['limit'] : 1000;
        $order['field'] = !empty($_GET['order_by']) ? $_GET['order_by'] : 'Date' ;
        $order['type'] = !empty($_GET['order_type']) ? strtoupper($_GET['order_type']) : 'DESC' ;
        $type = !empty($_GET['listing_type']) ? $_GET['listing_type'] : false ;

        $where = array();
        $structure_tmp = $rlDb->getAll("SHOW FIELDS FROM `{db_prefix}listings`");

        foreach($structure_tmp as $k => $v)	{
            if ($disabled_fields && !in_array($v['Field'], $disabled_fields)) {
                $structure[] = strtolower($v['Field']);
            }
        }
        unset($_GET['format']);

        foreach($_GET as $k => $v) {
            $k = strtolower($k);

            if ($k == 'category') {
                $v = $rlDb->getOne('ID', "`Key` ='" . $v . "'", 'categories');
            } elseif ($k == 'account_id') {
                $v = $rlDb->getOne('ID', "`Username` ='" . $v . "'", 'accounts');
            }

            if ($structure && in_array($k, $structure) && $v) {
                $where[$k] = $v;
            }
        }

        $reefless->loadClass('XmlExport', null, 'xmlFeeds', $format);

        $fp = fopen($filename, 'w+');
        $rlXmlExport->export($fp, $where, $order, $total_limit, $type);
        fclose($fp);
    }
}

$fp = fopen($filename, 'rb');
header('Content-Type: text/xml; charset=utf-8');
header("Content-Length: " . filesize($filename));

fpassthru($fp);
fclose($fp);
exit;
