<?php

/******************************************************************************
 *
 *	PROJECT: Flynax Classifieds Software
 *	VERSION: 4.6.0
 *	LICENSE: FL7PX995723I - https://www.flynax.com/license-agreement.html
 *	PRODUCT: Auto Classifieds Script
 *	DOMAIN: autobsmllc.com
 *	FILE: RLINSTALL.CLASS.PHP
 *
 *	The software is a commercial product delivered under single, non-exclusive,
 *	non-transferable license for one domain or IP address. Therefore distribution,
 *	sale or transfer of the file in whole or in part without permission of Flynax
 *	respective owners is considered to be illegal and breach of Flynax License End
 *	User Agreement.
 *
 *	You are not allowed to remove this information from the file without permission
 *	of Flynax respective owners.
 *
 *	Flynax Classifieds Software 2023 |  All copyrights reserved.
 *
 *	https://www.flynax.com/
 *
 ******************************************************************************/

class rlInstall extends reefless
{    
    /**
    * Install plugin
    */
    public function install()
    {
        $this->query("ALTER TABLE `" . RL_DBPREFIX . "categories` ADD `Icon` varchar(255) NOT NULL;");
        $this->query("ALTER TABLE `" . RL_DBPREFIX . "listing_types` ADD `Icon` varchar(255) NOT NULL;");

        $GLOBALS['rlCache']->updateCategories();
    }
    
    /**
    * Uninstall plugin
    */
    public function uninstall()
    {
        // remove category icons
        $cats = $this->fetch(array('Icon'), null, "WHERE `Icon` <> ''", null, 'categories');

        foreach($cats as $key => $value) {
            unlink(RL_FILES . $value['Icon']);
            unlink(RL_FILES . str_replace("icon", "icon_original", $value['Icon']));
        }

        $this->query("ALTER TABLE `" . RL_DBPREFIX . "categories` DROP `Icon`");
        $GLOBALS['rlCache']->updateCategories();
        
        // remove listing type icons
        if ($this->isExsistField('listing_types')) {
            $listing_types = $this->fetch(array('Icon'), null, "WHERE `Icon` <> ''", null, 'listing_types');

            foreach($listing_types as $key => $value) {
                unlink(RL_FILES . $value['Icon']);
                unlink(RL_FILES . str_replace("icon", "icon_original", $value['Icon']));
            }
            $this->query("ALTER TABLE `" . RL_DBPREFIX . "listing_types` DROP `Icon`");
        }
    }
    
    /**
    * Check if icon field exist in table
    * @param string $table
    */
    public function isExsistField($table)
    {
        $sql = "SHOW COLUMNS FROM `" . RL_DBPREFIX . $table . "`";
        $list_fields = $this->getAll($sql);
        
        foreach ($list_fields as $lfKey => $lfValue) {
            $fields[] = $lfValue['Field'];
        }
        if (in_array('Icon', $fields)) {
            return true;
        }
        return false;
    }
}

